#ifndef __COMMANDS_BINARY_H__
#define __COMMANDS_BINARY_H__

#include <stdint.h>

#define KEY_TYPE_AES128         0x00U   /**< AES 128 Key [16]. */
#define KEY_TYPE_AES192         0x01U   /**< AES 192 Key [24]. */
#define KEY_TYPE_AES256         0x02U   /**< AES 256 Key [32]. */
#define KEY_TYPE_DES            0x03U   /**< DES Single Key.   */
#define KEY_TYPE_2K3DES         0x04U   /**< 2 Key Triple Des. */
#define KEY_TYPE_3K3DES         0x05U   /**< 3 Key Triple Des. */
#define KEY_TYPE_MIFARE         0x06U   /**< MIFARE (R) Key. */

enum {
	WIFI_ON_OFF = 0x00,
	WIFI_MODE,
	WIFI_AUTH,
	WIFI_CHANNEL,
	WIFI_SID,
	WIFI_PASSWORD,
	DHCP_CLIENT,
	NET_ADDR,
	NET_NETMASK,
	NET_GATEWAY,
	NET_DNS,
	WEB_ADMIN,
	WEB_PASSWORD
}cmd_set_network_cfg;

enum {
	CMD_ACK = 0x00,
	CMD_DUMMY_COMMAND,
	CMD_GET_TAG_COUNT,
	CMD_GET_UID,
	CMD_ACTIVATE_TAG,
	CMD_HALT,
	CMD_SET_POLLING,
    CMD_SET_KEY,
	CMD_SAVE_KEYS,
	CMD_SET_NET_CFG,
	CMD_REBOOT,
	CMD_GET_VERSION,
	CMD_UART_PASSTHRU,

	//mifare clasics commands
	CMD_MF_READ_BLOCK = 0x20,
	CMD_MF_WRITE_BLOCK,
	CMD_MF_READ_VALUE,
	CMD_MF_WRITE_VALUE,
	CMD_MF_INCREMENT,
	CMD_MF_TRANSFER,
	CMD_MF_RESTORE,
	CMD_MF_TRANSFER_RESTORE,

	//mifare ultralight
	CMD_MFU_READ_PAGE = 0x40,
	CMD_MFU_WRITE_PAGE,
	CMD_MFU_GET_VERSION,
	CMD_MFU_READ_SIG,
	CMD_MFU_WRITE_SIG,
	CMD_MFU_LOCK_SIG,
	CMD_MFU_READ_COUNTER,
	CMD_MFU_INCREMENT_COUNTER,
	CMD_MFU_PASSWD_AUTH,
	CMD_MFUC_AUTHENTICATE,
	CMD_MFU_CHECKEVENT,

	CMD_MFDF_GET_VERSION = 0x60,
	CMD_MFDF_SELECT_APP,
	CMD_MFDF_APP_IDS,
	CMD_MFDF_FILE_IDS,
	CMD_MFDF_AUTH,
	CMD_MFDF_AUTH_ISO,
	CMD_MFDF_AUTH_AES,
	CMD_MFDF_CREATE_APP,
	CMD_MFDF_DELETE_APP,
	CMD_MFDF_CHANGE_KEY,
	CMD_MFDF_GET_KEY_SETTINGS,
	CMD_MFDF_CHANGE_KEY_SETTINGS,
	CMD_MFDF_CREATE_DATA_FILE,
	CMD_MFDF_WRITE_DATA,
	CMD_MFDF_READ_DATA,
	CMD_MFDF_CREATE_VALUE_FILE,
	CMD_MFDF_GET_VALUE,
	CMD_MFDF_CREDIT,
	CMD_MFDF_LIMITED_CREDIT,
	CMD_MFDF_DEBIT,
	CMD_MFDF_CREATE_RECORD_FILE,
	CMD_MFDF_WRITE_RECORD,
	CMD_MFDF_READ_RECORD,
	CMD_MFDF_CLEAR_RECORDS,
	CMD_MFDF_DELETE_FILE,
	CMD_MFDF_GET_FREEMEM,
	CMD_MFDF_FORMAT,
	CMD_MFDF_COMMIT_TRANSACTION,
	CMD_MFDF_ABORT_TRANSACTION,

	CMD_ICODE_INVENTORY_START = 0x90,
	CMD_ICODE_INVENTORY_NEXT,
	CMD_ICODE_STAY_QUIET,
	CMD_ICODE_READ_BLOCK,
	CMD_ICODE_WRITE_BLOCK,
	CMD_ICODE_LOCK_BLOCK,
	CMD_ICODE_WRITE_AFI,
	CMD_ICODE_LOCK_AFI,
	CMD_ICODE_WRITE_DSFID,
	CMD_ICODE_LOCK_DSFID,
	CMD_ICODE_GET_SYSTEM_INFORMATION,
	CMD_ICODE_GET_MULTIPLE_BSS,
	CMD_ICODE_PASSWORD_PROTECT_AFI,
	CMD_ICODE_READ_EPC,
	CMD_ICODE_GET_NXP_SYSTEM_INFORMATION,
	CMD_ICODE_GET_RANDOM_NUMBER,
	CMD_ICODE_SET_PASSWORD,
	CMD_ICODE_WRITE_PASSWORD,
	CMD_ICODE_LOCK_PASSWORD,
	CMD_ICODE_PROTECT_PAGE,
	CMD_ICODE_LOCK_PAGE_PROTECTION,
	CMD_ICODE_GET_MULTIPLE_BPS,
	CMD_ICODE_DESTROY,
	CMD_ICODE_ENABLE_PRIVACY,
	CMD_ICODE_ENABLE_64BIT_PASSWORD,
	CMD_ICODE_READ_SIGNATURE,
	CMD_ICODE_READ_CONFIG,
	CMD_ICODE_WRITE_CONFIG,
	CMD_ICODE_PICK_RANDOM_ID,

	CMD_ICODE_SET_EAS,
	CMD_ICODE_RESET_EAS,
	CMD_ICODE_LOCK_EAS,
	CMD_ICODE_EAS_ALARM,
	CMD_ICODE_PASSWORD_PROTECT_EAS,
	CMD_ICODE_WRITE_EASID,

	CMD_ASYNC 	= 0xFE,
 	CMD_ERROR	= 0xFF,
} cmd_binary_num;

void commands_execute_binary(uint8_t *buff, size_t len);

#endif

